<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class DailySaleItemResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'dailySaleId' => $this->daily_sale_id,
            'itemName' => $this->item_name,
            'qty' => $this->qty,
            'dp' => (float) $this->dp,
            'tp' => (float) $this->tp,
            'totalTP' => (float) $this->total_tp,
            'totalDP' => (float) $this->total_dp,
            'profit' => (float) $this->profit,
        ];
    }
}
