<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class DailySaleResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'date' => $this->date->format('d/m/Y'),
            'invoiceNumber' => $this->invoice_number,
            'customerName' => $this->customer_name,
            'customerPhone' => $this->customer_phone,
            'customerAddress' => $this->customer_address,
            'totalTP' => (float) $this->total_tp,
            'totalDP' => (float) $this->total_dp,
            'totalProfit' => (float) $this->total_profit,
            'dueAmount' => (float) $this->due_amount,
            'paidAmount' => (float) $this->paid_amount,
            'discount' => (float) $this->discount,
            'netProfit' => (float) $this->net_profit,
            'items' => DailySaleItemResource::collection($this->whenLoaded('items')),
            'created_at' => $this->created_at?->toISOString(),
            'updated_at' => $this->updated_at?->toISOString(),
        ];
    }
}
