import { getSalesTrend } from "@/data/stockData";
import {
  AreaChart,
  Area,
  XAxis,
  YAxis,
  CartesianGrid,
  Tooltip,
  ResponsiveContainer,
} from "recharts";

const SalesChart = () => {
  const data = getSalesTrend();

  return (
    <div className="glass-card rounded-xl p-5 animate-fade-in" style={{ animationDelay: "300ms" }}>
      <h3 className="text-lg font-bold font-display text-foreground mb-1">Sales Trend</h3>
      <p className="text-sm text-muted-foreground mb-4">Daily sales vs cost over time</p>
      <div className="h-[280px]">
        <ResponsiveContainer width="100%" height="100%">
          <AreaChart data={data} margin={{ top: 5, right: 10, left: 0, bottom: 5 }}>
            <defs>
              <linearGradient id="colorSales" x1="0" y1="0" x2="0" y2="1">
                <stop offset="5%" stopColor="hsl(152, 60%, 36%)" stopOpacity={0.3} />
                <stop offset="95%" stopColor="hsl(152, 60%, 36%)" stopOpacity={0} />
              </linearGradient>
              <linearGradient id="colorCost" x1="0" y1="0" x2="0" y2="1">
                <stop offset="5%" stopColor="hsl(152, 45%, 50%)" stopOpacity={0.15} />
                <stop offset="95%" stopColor="hsl(152, 45%, 50%)" stopOpacity={0} />
              </linearGradient>
            </defs>
            <CartesianGrid strokeDasharray="3 3" stroke="hsl(145, 20%, 90%)" />
            <XAxis dataKey="date" tick={{ fontSize: 12, fill: "hsl(160, 10%, 45%)" }} />
            <YAxis tick={{ fontSize: 12, fill: "hsl(160, 10%, 45%)" }} />
            <Tooltip
              contentStyle={{
                backgroundColor: "hsl(0, 0%, 100%)",
                border: "1px solid hsl(145, 20%, 90%)",
                borderRadius: "8px",
                boxShadow: "0 4px 12px rgba(0,0,0,0.08)",
              }}
              formatter={(value: number, name: string) => [
                `৳${value.toLocaleString()}`,
                name === "sales" ? "Sales" : name === "cost" ? "Cost" : "Profit",
              ]}
            />
            <Area
              type="monotone"
              dataKey="sales"
              stroke="hsl(152, 60%, 36%)"
              strokeWidth={2.5}
              fill="url(#colorSales)"
            />
            <Area
              type="monotone"
              dataKey="cost"
              stroke="hsl(152, 45%, 50%)"
              strokeWidth={2}
              fill="url(#colorCost)"
              strokeDasharray="5 5"
            />
          </AreaChart>
        </ResponsiveContainer>
      </div>
    </div>
  );
};

export default SalesChart;
