import { getTopSellingItems } from "@/data/stockData";
import {
  BarChart,
  Bar,
  XAxis,
  YAxis,
  CartesianGrid,
  Tooltip,
  ResponsiveContainer,
  Cell,
} from "recharts";

const TopProductsChart = () => {
  const data = getTopSellingItems();

  const colors = [
    "hsl(152, 60%, 30%)",
    "hsl(152, 60%, 36%)",
    "hsl(152, 55%, 42%)",
    "hsl(152, 50%, 48%)",
    "hsl(152, 45%, 54%)",
    "hsl(145, 40%, 60%)",
    "hsl(145, 35%, 66%)",
    "hsl(140, 30%, 72%)",
  ];

  return (
    <div className="glass-card rounded-xl p-5 animate-fade-in" style={{ animationDelay: "400ms" }}>
      <h3 className="text-lg font-bold font-display text-foreground mb-1">Top Selling Products</h3>
      <p className="text-sm text-muted-foreground mb-4">By total units sold across all days</p>
      <div className="h-[280px]">
        <ResponsiveContainer width="100%" height="100%">
          <BarChart data={data} layout="vertical" margin={{ top: 5, right: 20, left: 10, bottom: 5 }}>
            <CartesianGrid strokeDasharray="3 3" stroke="hsl(145, 20%, 90%)" horizontal={false} />
            <XAxis type="number" tick={{ fontSize: 12, fill: "hsl(160, 10%, 45%)" }} />
            <YAxis
              dataKey="name"
              type="category"
              width={140}
              tick={{ fontSize: 11, fill: "hsl(160, 10%, 45%)" }}
            />
            <Tooltip
              contentStyle={{
                backgroundColor: "hsl(0, 0%, 100%)",
                border: "1px solid hsl(145, 20%, 90%)",
                borderRadius: "8px",
                boxShadow: "0 4px 12px rgba(0,0,0,0.08)",
              }}
              formatter={(value: number) => [`${value} units`, "Sold"]}
            />
            <Bar dataKey="qty" radius={[0, 6, 6, 0]} barSize={20}>
              {data.map((_, index) => (
                <Cell key={`cell-${index}`} fill={colors[index % colors.length]} />
              ))}
            </Bar>
          </BarChart>
        </ResponsiveContainer>
      </div>
    </div>
  );
};

export default TopProductsChart;
