import { useState, useCallback } from "react";
import { products as initialProducts } from "@/data/stockData";

export interface Product {
  id: number;
  name: string;
  nickname: string;
  category: string;
}

export const useProductManager = () => {
  const [productList, setProductList] = useState<Product[]>(() => [...initialProducts]);

  const addProduct = useCallback((product: Omit<Product, "id">) => {
    setProductList((prev) => {
      const maxId = prev.length > 0 ? Math.max(...prev.map((p) => p.id)) : 1000;
      return [...prev, { ...product, id: maxId + 1 }];
    });
  }, []);

  const updateProduct = useCallback((id: number, product: Omit<Product, "id">) => {
    setProductList((prev) =>
      prev.map((p) => (p.id === id ? { ...product, id } : p))
    );
  }, []);

  const deleteProduct = useCallback((id: number) => {
    setProductList((prev) => prev.filter((p) => p.id !== id));
  }, []);

  return { productList, addProduct, updateProduct, deleteProduct };
};
