<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreDailySaleRequest;
use App\Http\Resources\DailySaleResource;
use App\Models\DailySale;
use App\Services\SalesService;
use Illuminate\Http\Request;

class DailySaleController extends Controller
{
    public function __construct(private SalesService $salesService)
    {
    }

    public function index(Request $request)
    {
        $query = DailySale::with('items')->orderBy('date', 'desc');

        // Optional date filtering
        if ($request->has('start_date')) {
            $query->where('date', '>=', $request->start_date);
        }
        if ($request->has('end_date')) {
            $query->where('date', '<=', $request->end_date);
        }

        $sales = $query->get();

        return DailySaleResource::collection($sales);
    }

    public function store(StoreDailySaleRequest $request)
    {
        $dailySale = $this->salesService->createDailySale($request->validated());

        return new DailySaleResource($dailySale);
    }

    public function show(DailySale $dailySale)
    {
        return new DailySaleResource($dailySale->load('items'));
    }

    public function destroy(DailySale $dailySale)
    {
        $dailySale->delete();

        return response()->json(['message' => 'Daily sale deleted successfully']);
    }
}
