<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class StockItemResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'itemName' => $this->item_name,
            'vendor' => $this->vendor,
            'stockInDate' => $this->stock_in_date?->format('d/m/Y'),
            'stockInQty' => $this->stock_in_qty,
            'stockOutDate' => $this->stock_out_date?->format('d/m/Y'),
            'stockOutQty' => $this->stock_out_qty,
            'costPrice' => (float) $this->cost_price,
            'stockBalance' => $this->stock_balance,
            'sellingPrice' => (float) $this->selling_price,
            'totalSalesRate' => (float) $this->total_sales_rate,
            'totalStockRate' => (float) $this->total_stock_rate,
            'created_at' => $this->created_at?->toISOString(),
            'updated_at' => $this->updated_at?->toISOString(),
        ];
    }
}
