<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Product;
use App\Models\Category;

class ProductSeeder extends Seeder
{
    public function run(): void
    {
        $products = [
            ['id' => 1001, 'name' => 'Pen (3/-)', 'nickname' => 'Pen', 'category' => 'Stationery'],
            ['id' => 1002, 'name' => 'Design Roller', 'nickname' => 'Dn Roller', 'category' => 'Stationery'],
            ['id' => 1003, 'name' => 'Design Scale', 'nickname' => 'Dn Scale', 'category' => 'Stationery'],
            ['id' => 1004, 'name' => 'Large Scale', 'nickname' => 'Large Scale', 'category' => 'Stationery'],
            ['id' => 1005, 'name' => 'Uno Card', 'nickname' => 'Uno Card', 'category' => 'Games'],
            ['id' => 1006, 'name' => 'Pokimon Card', 'nickname' => 'Pok Card', 'category' => 'Games'],
            ['id' => 1007, 'name' => 'BTS Card', 'nickname' => 'BTS Card', 'category' => 'Games'],
            ['id' => 1008, 'name' => 'Baby Tab (Writing Practice)', 'nickname' => 'Baby Tab', 'category' => 'Kids'],
            ['id' => 1009, 'name' => '3D Cute Cartoon Protective Case', 'nickname' => '3D Case', 'category' => 'Accessories'],
            ['id' => 1010, 'name' => 'High Quality Kitchen Toy (Kids)', 'nickname' => 'Kitchen Toy', 'category' => 'Kids'],
            ['id' => 1011, 'name' => 'Low Category Small Bag', 'nickname' => 'Small Bag', 'category' => 'Bags'],
            ['id' => 1012, 'name' => 'Cartoon Style Kids Bag', 'nickname' => 'Kids Bag', 'category' => 'Bags'],
            ['id' => 1013, 'name' => 'Cute Charger Cover', 'nickname' => 'Charger Cover', 'category' => 'Accessories'],
            ['id' => 1014, 'name' => 'X 0', 'nickname' => 'X 0', 'category' => 'Games'],
            ['id' => 1015, 'name' => 'Tennis Ball', 'nickname' => 'Tennis Ball', 'category' => 'Sports'],
            ['id' => 1016, 'name' => 'Seasonal Game', 'nickname' => 'Seasonal Game', 'category' => 'Games'],
            ['id' => 1017, 'name' => 'Badminton', 'nickname' => 'Batt', 'category' => 'Sports'],
            ['id' => 1018, 'name' => 'Football', 'nickname' => 'Football', 'category' => 'Sports'],
            ['id' => 1022, 'name' => 'Airpod', 'nickname' => 'Airpod', 'category' => 'Electronics'],
            ['id' => 1023, 'name' => 'Nick Band', 'nickname' => 'Nick Band', 'category' => 'Electronics'],
            ['id' => 1024, 'name' => 'Gaming Head Phone', 'nickname' => 'Gaming Earphone', 'category' => 'Electronics'],
            ['id' => 1025, 'name' => 'Bluetooth Speaker', 'nickname' => 'BT Speaker', 'category' => 'Electronics'],
            ['id' => 1026, 'name' => 'Mobile Stand', 'nickname' => 'Mobile Stand', 'category' => 'Accessories'],
            ['id' => 1027, 'name' => 'Power Bank', 'nickname' => 'Power Bank', 'category' => 'Electronics'],
            ['id' => 1028, 'name' => 'Digital Hand Weigher', 'nickname' => 'Hand Weigher', 'category' => 'Electronics'],
            ['id' => 1029, 'name' => 'Smart Watch', 'nickname' => 'Smart Watch', 'category' => 'Electronics'],
        ];

        foreach ($products as $productData) {
            $category = Category::where('name', $productData['category'])->first();

            Product::create([
                'id' => $productData['id'],
                'name' => $productData['name'],
                'nickname' => $productData['nickname'],
                'category_id' => $category->id,
            ]);
        }
    }
}
